﻿Imports System.IO
Imports System.Drawing.Text
Imports BaiqiSoft.BarcodeControl


Friend Class frmDemo
    Inherits System.Windows.Forms.Form


    Private Sub ResetStatusBar()
        StatusBar.Items.Item("sb_Barcode").Text = "Barcode Size: " & BarcodeView1.BarcodeWidth & " x " & BarcodeView1.BarcodeHeight
    End Sub

    Private Sub frmDemo_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeComponent()

        'Barcode1.LicenseKey = "Enter Your License Key Here"

        'BarcodeType
        cboBarcodeType.Items.Add("EAN/JAN-13")
        cboBarcodeType.Items.Add("EAN/JAN-8")
        cboBarcodeType.Items.Add("Code39")
        cboBarcodeType.Items.Add("Code39Extended")
        cboBarcodeType.Items.Add("Code93")
        cboBarcodeType.Items.Add("Code93Extended")
        cboBarcodeType.Items.Add("Codabar")
        cboBarcodeType.Items.Add("Code128 Auto")
        cboBarcodeType.Items.Add("Code128A")
        cboBarcodeType.Items.Add("Code128B")
        cboBarcodeType.Items.Add("Code128C")
        cboBarcodeType.Items.Add("Code11")
        cboBarcodeType.Items.Add("UPCA")
        cboBarcodeType.Items.Add("UPCE")
        cboBarcodeType.Items.Add("Standard2of5")
        cboBarcodeType.Items.Add("Interleaved2of5")
        cboBarcodeType.Items.Add("UCC/EAN-128")
        cboBarcodeType.Items.Add("GS1-128")
        cboBarcodeType.Items.Add("PDF 417")
        cboBarcodeType.Items.Add("QRCode")
        cboBarcodeType.Items.Add("Aztec")
        cboBarcodeType.Items.Add("DataMatrix")
        cboBarcodeType.Items.Add("ITF-14")
        cboBarcodeType.Items.Add("ISBN/ISMN/ISSN")
        cboBarcodeType.Items.Add("Industrial2of5")
        cboBarcodeType.Items.Add("MSI/Plessey")
        cboBarcodeType.Items.Add("Telepen")
        cboBarcodeType.Items.Add("Postnet")
        cboBarcodeType.Items.Add("Pharmacode")
        cboBarcodeType.Items.Add("GS1 DataMatrix")
        cboBarcodeType.Items.Add("GS1 QRCode")
        cboBarcodeType.Items.Add("Micro QRCode")
        cboBarcodeType.Items.Add("Micro PDF417")
        cboBarcodeType.Items.Add("UCC/EAN-14")
        cboBarcodeType.Items.Add("SSCC-18")

        'Font Name
        Dim installedFontCollection As New InstalledFontCollection()
        Dim fontFamilies() As FontFamily = installedFontCollection.Families
        For i As Integer = 0 To fontFamilies.Length - 1
            cboFontName.Items.Add(fontFamilies(i).Name)
        Next i

        'FontSize
        For i As Integer = 5 To 72
            cboFontSize.Items.Add(CStr(i))
        Next i

        'LoadData
        txtBarcodeText.Text = BarcodeView1.Text
        cboBarcodeType.SelectedIndex = BarcodeView1.CodeType
        Select Case BarcodeView1.Rotate
            Case Rotate.None
                bt_Rotate.Image = bt_None.Image
            Case Rotate.Degree90
                bt_Rotate.Image = bt_Degree90.Image
            Case Rotate.Degree180
                bt_Rotate.Image = bt_Degree180.Image
            Case Rotate.Degree270
                bt_Rotate.Image = bt_Degree270.Image
        End Select
        bt_CheckSum.Checked = BarcodeView1.CheckSum
        bt_ShowText.Checked = BarcodeView1.ShowText
        Select Case BarcodeView1.TextAlignment
            Case BarcodeTextAlign.TopLeft
                bt_TextAlign.Image = bt_TopLeft.Image
            Case BarcodeTextAlign.TopCenter
                bt_TextAlign.Image = bt_TopCenter.Image
            Case BarcodeTextAlign.TopRight
                bt_TextAlign.Image = bt_TopRight.Image
            Case BarcodeTextAlign.TopExpand
                bt_TextAlign.Image = bt_TopExpand.Image
            Case BarcodeTextAlign.BottomLeft
                bt_TextAlign.Image = bt_BottomLeft.Image
            Case BarcodeTextAlign.BottomCenter
                bt_TextAlign.Image = bt_BottomCenter.Image
            Case BarcodeTextAlign.BottomRight
                bt_TextAlign.Image = bt_BottomRight.Image
            Case BarcodeTextAlign.BottomExpand
                bt_TextAlign.Image = bt_BottomExpand.Image
        End Select

        cboFontName.Text = BarcodeView1.FontName
        cboFontSize.Text = BarcodeView1.FontSize
        bt_FontBold.Checked = BarcodeView1.FontBold
        bt_FontItalic.Checked = BarcodeView1.FontItalic

        cboSupplementType.Text = BarcodeView1.SupplementType.ToString
        txtSupplement.Text = BarcodeView1.SupplementText
        txtLeftGap.Text = BarcodeView1.SupplementLeftGap
        txtTopGap.Text = BarcodeView1.SupplementTopGap

        ResetStatusBar()
        frmDemo_Resize(Me, EventArgs.Empty)

        MessageBox.Show("The Font cannot be changed in the trial version.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
    End Sub

    Private Sub frmDemo_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        picFrame.Left = 0
        picFrame.Top = ToolBarFont.Top + ToolBarFont.Height
        picFrame.Width = Me.ClientRectangle.Width
        picFrame.Height = StatusBar.Top - picFrame.Top
        BarcodeView1.Left = picFrame.Left + 5
        BarcodeView1.Top = picFrame.Top + 5
        BarcodeView1.Width = picFrame.Width - 10
        BarcodeView1.Height = picFrame.Height - 10
    End Sub

    Private Sub txtBarcodeText_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtBarcodeText.TextChanged
        BarcodeView1.Text = txtBarcodeText.Text
    End Sub

    Private Sub cboFontSize_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontSize.SelectedIndexChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            BarcodeView1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboFontSize_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontSize.TextChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            BarcodeView1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboFontName_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontName.SelectedIndexChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            BarcodeView1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboFontName_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontName.TextChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            BarcodeView1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboBarcodeType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboBarcodeType.SelectedIndexChanged
        BarcodeView1.CodeType = cboBarcodeType.SelectedIndex
        BarcodeView1.Text = txtBarcodeText.Text
    End Sub

    Private Sub cboBarcodeType_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboBarcodeType.TextChanged
        BarcodeView1.CodeType = cboBarcodeType.SelectedIndex
        BarcodeView1.Text = txtBarcodeText.Text
    End Sub

    Private Sub bt_FontBold_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_FontBold.Click
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            BarcodeView1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub bt_FontItalic_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_FontItalic.Click
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            BarcodeView1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub bt_CheckSum_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_CheckSum.Click
        BarcodeView1.CheckSum = bt_CheckSum.Checked
    End Sub

    Private Sub bt_ShowText_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_ShowText.Click
        BarcodeView1.ShowText = bt_ShowText.Checked
    End Sub


    Private Sub bt_ShowIndicator_Click(sender As System.Object, e As System.EventArgs) Handles bt_ShowIndicator.Click
        BarcodeView1.ShowIndicator = bt_ShowIndicator.Checked
    End Sub

    Private Sub bt_ShowStartStopChar_Click(sender As System.Object, e As System.EventArgs) Handles bt_ShowStartStopChar.Click
        BarcodeView1.ShowStartStopChar = bt_ShowStartStopChar.Checked
    End Sub

    Private Sub bt_TopLeft_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopLeft.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.TopLeft
        bt_TextAlign.Image = bt_TopLeft.Image
    End Sub

    Private Sub bt_TopCenter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopCenter.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.TopCenter
        bt_TextAlign.Image = bt_TopCenter.Image
    End Sub

    Private Sub bt_TopRight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopRight.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.TopRight
        bt_TextAlign.Image = bt_TopRight.Image
    End Sub

    Private Sub bt_TopExpand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopExpand.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.TopExpand
        bt_TextAlign.Image = bt_TopExpand.Image
    End Sub

    Private Sub bt_BottomLeft_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomLeft.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.BottomLeft
        bt_TextAlign.Image = bt_BottomLeft.Image
    End Sub

    Private Sub bt_BottomCenter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomCenter.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.BottomCenter
        bt_TextAlign.Image = bt_BottomCenter.Image
    End Sub

    Private Sub bt_BottomRight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomRight.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.BottomRight
        bt_TextAlign.Image = bt_BottomRight.Image
    End Sub

    Private Sub bt_BottomExpand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomExpand.Click
        BarcodeView1.TextAlignment = BarcodeTextAlign.BottomExpand
        bt_TextAlign.Image = bt_BottomExpand.Image
    End Sub

    Private Sub bt_None_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_None.Click
        BarcodeView1.Rotate = Rotate.None
        bt_Rotate.Image = bt_None.Image
    End Sub

    Private Sub bt_Degree90_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Degree90.Click
        BarcodeView1.Rotate = Rotate.Degree90
        bt_Rotate.Image = bt_Degree90.Image
    End Sub

    Private Sub bt_Degree180_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Degree180.Click
        BarcodeView1.Rotate = Rotate.Degree180
        bt_Rotate.Image = bt_Degree180.Image
    End Sub

    Private Sub bt_Degree270_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Degree270.Click
        BarcodeView1.Rotate = Rotate.Degree270
        bt_Rotate.Image = bt_Degree270.Image
    End Sub

    Private Sub bt_BackColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BackColor.Click
        ColorDialog1.Color = BarcodeView1.BackColor
        ColorDialog1.ShowDialog()
        BarcodeView1.BackColor = ColorDialog1.Color
    End Sub

    Private Sub bt_ForeColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_ForeColor.Click
        ColorDialog1.Color = BarcodeView1.ForeColor
        ColorDialog1.ShowDialog()
        BarcodeView1.ForeColor = ColorDialog1.Color
    End Sub

    Private Sub bt_Layout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Layout.Click
        frmLayout.ShowDialog()
        ResetStatusBar()
    End Sub

    Private Sub mm_Help_HelpOnline_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_HelpOnline.Click
        BarcodeView.OpenWebLink("http://www.mysofttool.com/help/barcodecontrol")
    End Sub

    Private Sub mm_Help_CheckUpdates_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_CheckUpdates.Click
        BarcodeView.OpenWebLink("http://www.mysofttool.com")
    End Sub

    Private Sub mm_Help_PurchaseNow_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_PurchaseNow.Click
        BarcodeView.OpenWebLink("http://www.mysofttool.com/purchase/")
    End Sub

    Private Sub mm_Help_About_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_About.Click
        BarcodeView1.AboutBox()
    End Sub

    Private Sub cboSupplementType_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles cboSupplementType.SelectedIndexChanged
        BarcodeView1.SupplementType = cboSupplementType.SelectedIndex
    End Sub

    Private Sub txtSupplement_TextChanged(sender As Object, e As System.EventArgs) Handles txtSupplement.TextChanged
        BarcodeView1.SupplementText = txtSupplement.Text
    End Sub

    Private Sub txtLeftGap_TextChanged(sender As Object, e As System.EventArgs) Handles txtLeftGap.TextChanged
        BarcodeView1.SupplementLeftGap = Single.Parse(txtLeftGap.Text)
    End Sub

    Private Sub txtTopGap_TextChanged(sender As Object, e As System.EventArgs) Handles txtTopGap.TextChanged
        BarcodeView1.SupplementTopGap = Single.Parse(txtTopGap.Text)
    End Sub

    Private Sub btnDllSample_Click(sender As System.Object, e As System.EventArgs) Handles btnDllSample.Click
        frmDllSample.ShowDialog()
    End Sub
End Class
